unit Unit1;

//      ,
//         
//    .

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, TypInfo, Grids, ExtCtrls, Buttons, Menus;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    StringGrid1: TStringGrid;
    ComboBox1: TComboBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    procedure ComboBox1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

//  TTypeKind = (tkUnknown, tkInteger, tkChar, tkEnumeration, tkFloat,
//               tkString, tkSet, tkClass, tkMethod, tkWChar, tkLString,
//               tkWString, tkVariant, tkArray, tkRecord, tkInterface,
//               tkInt64, tkDynArray);

//    
procedure ShowClassProrerty (PListProp : PPropList;
                             PropCount : Integer;
                             Report    : TStringGrid);
var Ind     : integer;
    WStr    : string;
begin
  Report.RowCount := PropCount + Report.FixedRows;
  Report.Cells[0,0] := '';
  Report.Cells[1,0] := ' ';
  Report.Cells[2,0] := ' ';
  for Ind := 0 to PropCount - 1 do
  begin
      //  
      Wstr := '';
      case PListProp^[Ind].PropType^.Kind of
      tkUnknown     : WStr := '';
      tkInteger     : WStr := 'Integer';
      tkChar        : WStr := 'Char';
      tkEnumeration : WStr := 'Enumeration';
      tkFloat       : WStr := 'Float';
      tkString      : WStr := 'String';
      tkSet         : WStr := 'Set';
      tkClass       : WStr := 'Class';
      tkMethod      : WStr := 'Method';
      tkWChar       : WStr := 'WChar';
      tkLString     : WStr := 'LString';
      tkWString     : WStr := 'WString';
      tkVariant     : WStr := 'Variant';
      tkArray       : WStr := 'Array';
      tkRecord      : WStr := 'Record';
      tkInterface   : WStr := 'Interface';
      tkInt64       : WStr := 'Int64';
      tkDynArray    : WStr := 'DynArray';
      end;
      //  
      Report.Cells[0, Ind + Report.FixedRows] := Wstr;
      //   
      Report.Cells[1, Ind + Report.FixedRows] := PListProp^[Ind].Name;
      //   
      Report.Cells[2, Ind + Report.FixedRows] := PListProp^[Ind].PropType^.Name;
  end;
end;

//    
procedure EnumClassProrerty(RqClass : TClass; Report : TStringGrid);
var
  ATypeInfo  : PTypeInfo;  //   
  ATypeData  : PTypeData;
  PropCount  : Integer;    //  
  PListProp  : PPropList;  //   
begin
  //        
  ATypeInfo  := PTypeInfo(RqClass.ClassInfo);
  ATypeData  := GetTypeData(ATypeInfo);
  PropCount  := ATypeData^.PropCount;
  if PropCount > 0 then
  begin
    GetMem(PListProp, PropCount * SizeOf(Pointer));
    GetPropInfos(ATypeInfo, PListProp);
    ShowClassProrerty(PListProp,PropCount,Report);
    FreeMem(PListProp, PropCount * SizeOf(Pointer));
  end;
end;

//   
procedure TForm1.ComboBox1Click(Sender: TObject);
begin
     case ComboBox1.ItemIndex of
     0  : EnumClassProrerty(TButton,      StringGrid1);
     1  : EnumClassProrerty(TBitBtn,      StringGrid1);
     2  : EnumClassProrerty(TEdit,        StringGrid1);
     3  : EnumClassProrerty(TPopupMenu,   StringGrid1);
     4  : EnumClassProrerty(TRadioButton, StringGrid1);
     5  : EnumClassProrerty(TRadioGroup,  StringGrid1);
     6  : EnumClassProrerty(TPanel,       StringGrid1);
     7  : EnumClassProrerty(TCheckBox,    StringGrid1);
     8  : EnumClassProrerty(TForm,        StringGrid1);
     9  : EnumClassProrerty(TComboBox,    StringGrid1);
     10 : EnumClassProrerty(TGroupBox,    StringGrid1);
     11 : EnumClassProrerty(TSpeedButton, StringGrid1);
     12 : EnumClassProrerty(TLabel,       StringGrid1);
     13 : EnumClassProrerty(TListBox,     StringGrid1);
     14 : EnumClassProrerty(TMainMenu,    StringGrid1);
     15 : EnumClassProrerty(TMemo,        StringGrid1);
     end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  ComboBox1Click(nil);
end;

end.
